#pragma once

#include "Service.h"
#include "ConfigGPRS.h"
//////////////////////////////////////////////////////////////////////////

#ifdef DLLMANAGER_EXPORTS
	#define DLLMANAGER_API __declspec(dllexport)
#else
	#define DLLMANAGER_API __declspec(dllimport) 
#endif
//////////////////////////////////////////////////////////////////////////
#define kRemoveMode			0
#define kReqMode			1
#define kMinMode			2
//////////////////////////////////////////////////////////////////////////

class DLLMANAGER_API CServiceGPRS : public CService
{
public:
	CServiceGPRS();
	CServiceGPRS(CDllManager* iDllManager);
	~CServiceGPRS();
	virtual Bool Dispatch(CCmd* iCmdP);
	virtual void OnConfigChange(int iConfigID);
	virtual void OnConfigChange(int iConfigID, int iConfigEvent);

	virtual Bool CGREG(CCmd* iCmdP, Bool iSilentMode=0);
	virtual void CGREGGetLocalInfo(CCmd* iCmdP, Bool iSilentMode);
	virtual Bool CGDCONT(CCmd* iCmdP, Bool iSilentMode=0);
	virtual Bool CGATT(CCmd* iCmdP, Bool iSilentMode=0);
	virtual Bool CGACT(CCmd* iCmdP, Bool iSilentMode=0);
	virtual Bool CGPADDR(CCmd* iCmdP, Bool iSilentMode=0);
	virtual Bool CGQREQ(CCmd* iCmdP, Bool iSilentMode=0);
	virtual Bool CGQREQList(CCmd* iCmdP, Bool iSilentMode=0);
	virtual Bool CGQMIN(CCmd* iCmdP, Bool iSilentMode=0);
	virtual Bool CGQMINList(CCmd* iCmdP, Bool iSilentMode=0);
	virtual Bool CGEREP(CCmd* iCmdP, Bool iSilentMode=0);
	virtual Bool CGSMS(CCmd* iCmdP, Bool iSilentMode=0);
	virtual Bool CGCLASS(CCmd* iCmdP, Bool iSilentMode=0);
protected:	
	Bool PrvSetToUndefined(CCmd* iCmdP, Bool iSilentMode=0, UInt8 iMinReq=kRemoveMode);
	Bool PrvGetCtxt(CGPRSContext* ioCtxt, UInt8 iCid, CCmd* iCmdP, Bool iSilentMode=0);
protected:
	int mUnknownOrMissingAPN;
};
//////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////